#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../common/cancel_appointment'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/booked_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/landing_notifications'


describe '[Story# VAR-12537: Location list selection: Indicate which locations have the patients PACT clinics]
          [Story# VAR-12800: Feature Flag for PACT Team]'  do

  include DriverUtility
  include OracleUtility
  include DateUtility
  include MongoUtility


  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_appointment = NewAppointmentRequest.new(@driver)
    @detail = BookedAppointmentDetail.new(@driver)
    @landing_notifications = LandingNotifications.new(@driver)
    TITLE = "Appointments/Requests"
    @tomorrow = getDateNthDaysFromNow(1, "%m/%d/%Y")
    @sevenDaysFromNow = getDateNthDaysFromNow(7, "%m/%d/%Y")
    @nintyDaysLater = getDateNthDaysFromNow(90, "%m/%d/%Y")
    @@timeSlot = "11:00"
    @@patientID ="1113138327"
    #cancel appointment

    @cancel_appointment = CancelAppointment.new("CLINIC_BASED_BOSTON", "523","#{pw_redacted['userid']}")
    @cancel_appointment.update_appointment_obj("appointmentTime", "#{@sevenDaysFromNow} 11:00:00")
    @cancel_appointment.cancel_appointment()

    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    deletePatientData(@@patientID)
    @common.loginEndsOnHome(pw_redacted)
    @common.selectAddAppointmentButton("VA")
  end

  after(:all) do
      @driver.close
  end

    context 'AC#VAR-13173|TC#VAR-13219: Location Booking - Indicate which locations have the patients PACT clinics' do
      it 'No "Your primary Care Team" text display in case of a single facility' do
        @new_appointment.selectTypeOfCare(PRIMARY_CARE)
        @new_appointment.selectState("636")
        expect(@new_appointment.single_location_element).eql?("Omaha VA Medical Center (Omaha, NE)")
      end

      it 'verify it display "PACT team" link in case of a single facility' do
        @new_appointment.view_pact_team_element.when_present(TIME_OUT_LIMIT)
        @new_appointment.view_pact_team_element.click
        @modal.modalTitle_element.wait_until_present(TIME_OUT_LIMIT)
        expect(@modal.modalTitle_element.text).to eq "PACT Members"
        expected_content =[\
                    "Primary Care Providers:",
                    "Stephen Strange",
                    "Team List:"
        ]

        actual_content = @modal.content_element.text.split("\n")

        compareContents( expected_content, actual_content)
      end

      it 'should display "Your primary Care Team" text' do
        @modal.buttons_elements[0].click
        @new_appointment.selectTypeOfCare(PRIMARY_CARE)
        @new_appointment.selectState("523")
        @new_appointment.selectLocation("523")
        expect (@new_appointment.location_element.selected_options[0]).eql?("BOSTON HCS VAMC (BOSTON, MA) - Your Primary Care Team")
      end

      it 'verify "PACT team" link' do
        @new_appointment.view_pact_team_element.when_present(TIME_OUT_LIMIT)
        @new_appointment.view_pact_team_element.click
        @modal.modalTitle_element.wait_until_present(TIME_OUT_LIMIT)
        expect(@modal.modalTitle_element.text).to eq "PACT Members"
        expected_content =[\
                      "Primary Care Providers:",
                      "Creamer, Kent",
                      "Team List:",
                      "Gomez, Shane; McCormack, Asia; Parker, Corinna; Perry, Mary; Tate, Vickie"
        ]

        actual_content = @modal.content_element.text.split("\n")

        compareContents( expected_content, actual_content)
      end

      it "Verify user can successfully schedule an appointment" do
        @modal.buttons_elements[0].click
        @new_appointment.selectSchedulingMethod("direct")
        @new_appointment.selectClinic("32")
        @new_appointment.provideReasonForAppointment("schedule appointment with PACT Team")
        @new_appointment.selectPreferedDate(@sevenDaysFromNow, @@timeSlot)
        @new_appointment.enterEmail("testPC@test.com")
        @new_appointment.clickScheduleAppointment
        @detail.appointment_details_group_element.when_present(TIME_OUT_LIMIT)
        expect(@detail.primary_header).to eq("Appointment Details")
      end
    end
  end